<?php
require_once __DIR__ . '/src/bootstrap.php';
require_once __DIR__ . '/src/Share.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$filePath = $input['file_path'] ?? '';
$type = $input['type'] ?? 'link'; // 'link' or 'public'

if (!$filePath) {
    http_response_code(400);
    echo json_encode(['error' => 'File path required']);
    exit;
}

// Security: Verify file belongs to user
$prefix = $currentUser . '/';
if (strpos($filePath, $prefix) !== 0) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized access to file']);
    exit;
}

$share = new Share();
$token = $share->createShare($filePath, $currentUser, $type);

// Base URL for links
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$link = "$protocol://$host/shared.php?t=$token";

echo json_encode([
    'success' => true,
    'token' => $token,
    'link' => $link,
    'type' => $type
]);
