<?php
require_once __DIR__ . '/src/bootstrap.php';
require_once __DIR__ . '/src/Share.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['filename'])) {
    $filename = basename($_POST['filename']);
    $key = $currentUser . '/' . $filename;

    try {
        // Get size first to reclaim space
        $objects = $r2->listObjects($bucket, $key);
        $size = 0;
        foreach ($objects as $obj) {
            if ($obj['key'] === $key) {
                $size = $obj['size'];
                break;
            }
        }

        $r2->deleteObject($bucket, $key);

        // Decrement Storage & Upload Count
        $userObj->registerDelete($size);

        // Remove from Public/Private Shares
        $share = new Share();
        $share->deleteShareByPath($key);

        header('Location: index.php');
    } catch (Exception $e) {
        die("Delete failed: " . $e->getMessage());
    }
} else {
    header('Location: index.php');
}
