<?php
require_once __DIR__ . '/src/Share.php';
require_once __DIR__ . '/src/Auth.php';
require_once __DIR__ . '/src/User.php';

// Auth Check (Optional for Discover)
$auth = new Auth();
$currentUser = $auth->getUser();

if ($currentUser) {
    // If logged in, get user data for sidebar
    $userObj = new User($currentUser);
    $userData = $userObj->getData();
} else {
    $userData = null;
}

$share = new Share();
$publicFiles = $share->getPublicShares();

$search = $_GET['q'] ?? '';
if ($search) {
    $publicFiles = array_filter($publicFiles, function ($item) use ($search) {
        return stripos($item['file_path'], $search) !== false;
    });
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php $pageTitle = 'Discover';
    include 'components/head.php'; ?>
</head>

<body>
    <div class="app-container">
        <?php include 'components/sidebar.php'; ?>

        <div class="main-content">
            <div class="page-header" style="flex-direction: column; align-items: start; gap: 1rem;">
                <h2>Discover Files</h2>
                <form style="width: 100%; display: flex; gap: 1rem;">
                    <input type="text" name="q" placeholder="Search public files..."
                        value="<?= htmlspecialchars($search) ?>" style="margin:0; max-width: 400px;">
                    <button type="submit">Search</button>
                    <a href="discover.php" class="btn secondary">Clear</a>
                </form>
            </div>

            <div class="card">
                <?php if (empty($publicFiles)): ?>
                    <p class="text-muted" style="text-align: center;">No public files found.</p>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>File Name</th>
                                <th>Shared By</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($publicFiles as $token => $data): ?>
                                <tr>
                                    <td>
                                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                                            <div
                                                style="background: rgba(59, 130, 246, 0.1); padding: 0.5rem; border-radius: 8px;">
                                                <i data-feather="file"
                                                    style="width: 20px; height: 20px; color: var(--accent-primary)"></i>
                                            </div>
                                            <?= htmlspecialchars(basename($data['file_path'])) ?>
                                        </div>
                                    </td>
                                    <td class="text-muted">@<?= htmlspecialchars($data['owner']) ?></td>
                                    <td>
                                        <a href="shared.php?t=<?= $token ?>" class="btn-sm" target="_blank">
                                            <i data-feather="download"></i> Download
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <script>feather.replace();</script>
</body>

</html>