<?php
require_once __DIR__ . '/src/bootstrap.php';

if (isset($_GET['file'])) {
    $filename = basename($_GET['file']);
    $key = $currentUser . '/' . $filename;

    if (!$userObj->checkDownloadLimit()) {
        die("Download limit reached.");
    }

    try {
        $result = $r2->getObject($bucket, $key);

        if ($result['code'] !== 200) {
            die("File not found or R2 error.");
        }

        $userObj->registerDownload();

        // Forward headers?
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-Length: ' . strlen($result['body'])); // Note: PHP mem limit issue for large files.
        // For large files, stream context with curl would be better, but for "simple php", this works for avg files.

        echo $result['body'];
        exit;
    } catch (Exception $e) {
        die("Download failed: " . $e->getMessage());
    }
} else {
    header('Location: index.php');
}
