<?php
require_once __DIR__ . '/src/Auth.php';

$auth = new Auth();
$error = '';

if ($auth->isLoggedIn()) {
    $redirect = $auth->isAdmin() ? 'admin.php' : 'index.php';
    header("Location: $redirect");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if ($auth->login($username, $password)) {
        $redirect = $auth->isAdmin() ? 'admin.php' : 'index.php';
        header("Location: $redirect");
        exit;
    } else {
        $error = "Invalid credentials";
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - TurBay Cloud</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/style.css">
</head>

<body class="auth-page">
    <div class="card" style="width: 100%; max-width: 400px; padding: 2.5rem;">
        <h2 style="text-align: center; margin-bottom: 0.5rem; font-size: 1.75rem;">TurBay Cloud</h2>
        <p style="text-align: center; color: var(--text-secondary); margin-bottom: 2rem;">Sign in to your drive</p>

        <?php if ($error): ?>
            <div
                style="background: rgba(239, 68, 68, 0.1); border: 1px solid var(--danger); color: #fca5a5; padding: 0.75rem; border-radius: 8px; margin-bottom: 1.5rem; font-size: 0.9rem; text-align: center;">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <label
                style="display: block; margin-bottom: 0.5rem; color: var(--text-secondary); font-size: 0.9rem;">Username</label>
            <input type="text" name="username" required placeholder="Enter your username">

            <label
                style="display: block; margin-bottom: 0.5rem; color: var(--text-secondary); font-size: 0.9rem;">Password</label>
            <input type="password" name="password" required placeholder="Enter your password">

            <button type="submit" style="margin-top: 1rem; padding: 1rem;">Sign In</button>
        </form>
    </div>
</body>

</html>