<?php
require_once __DIR__ . '/src/bootstrap.php';
require_once __DIR__ . '/src/Share.php';

$token = $_GET['t'] ?? '';
if (!$token)
    die("Invalid link.");

$share = new Share();
$data = $share->getShare($token);

if (!$data)
    die("Link expired or invalid.");

$filePath = $data['file_path']; // e.g., 'username/file.ext'
$filename = basename($filePath);

// Increment downloads (analytics)
$share->incrementDownloads($token);

// Stream download
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');

// Stream from R2
try {
    $result = $r2->getObject($bucket, $filePath);
    echo $result['Body'];
} catch (Exception $e) {
    die("File not found or access denied.");
}
exit;
