<?php

class DB {
    private $filePath;
    private $data = [];

    public function __construct($filePath) {
        $this->filePath = $filePath;
        if (!file_exists($filePath)) {
            file_put_contents($filePath, json_encode([]));
        }
        $this->load();
    }

    private function load() {
        $json = file_get_contents($this->filePath);
        $this->data = json_decode($json, true) ?? [];
    }

    public function save() {
        file_put_contents($this->filePath, json_encode($this->data, JSON_PRETTY_PRINT));
    }

    public function get($key = null) {
        if ($key === null) {
            return $this->data;
        }
        return $this->data[$key] ?? null;
    }

    public function set($key, $value) {
        $this->data[$key] = $value;
        $this->save();
    }

    public function delete($key) {
        unset($this->data[$key]);
        $this->save();
    }

    public function getAll() {
        return $this->data;
    }
}
