<?php

class User
{
    private $username;
    private $db;

    public function __construct($username)
    {
        $this->username = $username;
        $this->db = new DB(__DIR__ . '/../data/users.json');
    }

    public function exists()
    {
        return $this->db->get($this->username) !== null;
    }

    public static function getAllUsers()
    {
        $db = new DB(__DIR__ . '/../data/users.json');
        return $db->getAll();
    }

    public function create($password, $storageLimit = 104857600, $downloadLimit = 50, $uploadLimit = 100, $packageName = 'Custom Plan')
    {
        if ($this->exists()) {
            return false;
        }
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $userData = [
            'password' => $hash,
            'role' => 'user',
            'package_name' => $packageName,
            'storage_limit' => $storageLimit,
            'used_storage' => 0,
            'download_limit' => $downloadLimit,
            'used_downloads' => 0,
            'upload_limit' => $uploadLimit,
            'used_uploads' => 0
        ];
        $this->db->set($this->username, $userData);
        return true;
    }

    public function getData()
    {
        return $this->db->get($this->username);
    }

    public function update($data)
    {
        $current = $this->getData();
        if (!$current)
            return false;

        foreach ($data as $k => $v) {
            $current[$k] = $v;
        }
        $this->db->set($this->username, $current);
        return true;
    }

    public function verifyPassword($password)
    {
        $data = $this->getData();
        if (!$data)
            return false;
        return password_verify($password, $data['password']);
    }

    public function registerDelete($size)
    {
        $data = $this->getData();
        if (!$data)
            return;

        $usedStorage = $data['used_storage'] ?? 0;
        $usedUploads = $data['used_uploads'] ?? 0;

        $newStorage = max(0, $usedStorage - $size);
        $newUploads = max(0, $usedUploads - 1);

        $this->update([
            'used_storage' => $newStorage,
            'used_uploads' => $newUploads
        ]);
    }
}
