<?php
require_once __DIR__ . '/Auth.php';
require_once __DIR__ . '/R2.php';
require_once __DIR__ . '/DB.php';
require_once __DIR__ . '/User.php';

$auth = new Auth();
$auth->requireLogin();

if ($auth->isAdmin()) {
    // Admin has own dashboard, but if they access user pages, treat careful?
    // For now, redirect admin to admin.php if they hit index.php
    if (basename($_SERVER['PHP_SELF']) == 'index.php') {
        header('Location: admin.php');
        exit;
    }
}

$start = new DB(__DIR__ . '/../data/config.json');
$config = $start->getAll();

if (empty($config['r2_endpoint']) || empty($config['r2_access_key'])) {
    die("System not configured. Please contact admin.");
}

$r2 = new R2($config['r2_endpoint'], $config['r2_access_key'], $config['r2_secret_key']);
$bucket = $config['r2_bucket'];
$currentUser = $auth->getUser();

$userObj = new User($currentUser);
