<?php
require_once __DIR__ . '/src/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_FILES['file'])) {
    header("Location: index.php");
    exit;
}

if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
    die("Upload failed with error code " . $_FILES['file']['error']);
}

$userData = $userObj->getData();
$currentUsage = $userData['used_storage'] ?? 0;
$limit = $userData['storage_limit'] ?? 0;
$size = $_FILES['file']['size'];

// Check Storage Limit
if ($limit > 0 && ($currentUsage + $size) > $limit) {
    die("Storage limit exceeded. Upgrade your plan.");
}

// Check Upload Count Limit
$uploadLimit = $userData['upload_limit'] ?? 100;
$usedUploads = $userData['used_uploads'] ?? 0;
if ($usedUploads >= $uploadLimit) {
    die("Upload count limit exceeded ($uploadLimit files max). Upgrade your plan.");
}

try {
    // Generate unique key: username/filename
    // Sanitize filename
    $filename = basename($_FILES['file']['name']);
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
    $key = $currentUser . '/' . $filename;

    // Use the streaming putObject method from R2 class
    $r2->putObject($bucket, $key, $_FILES['file']['tmp_name']);

    // Update usage
    $newUsage = $currentUsage + $size;
    $newUploadCount = $usedUploads + 1;

    $userObj->update([
        'used_storage' => $newUsage,
        'used_uploads' => $newUploadCount
    ]);

    header("Location: index.php");
    exit;
} catch (Exception $e) {
    die("Upload Error: " . $e->getMessage());
}
