<?php
require_once __DIR__ . '/src/Auth.php';
require_once __DIR__ . '/src/User.php';
require_once __DIR__ . '/src/DB.php';

$auth = new Auth();
$auth->requireAdmin();

$configParams = __DIR__ . '/data/config.json';
$configDB = new DB($configParams);
$msg = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'update_config') {
            $configDB->set('r2_endpoint', $_POST['r2_endpoint']);
            $configDB->set('r2_access_key', $_POST['r2_access_key']);
            $configDB->set('r2_secret_key', $_POST['r2_secret_key']);
            $configDB->set('r2_bucket', $_POST['r2_bucket']);
            $msg = "Configuration updated successfully.";
        } elseif ($_POST['action'] === 'create_user') {
            $u = new User($_POST['username']);
            $data = $u->getData();
            if ($data) {
                $error = "User already exists.";
            } else {
                $storage = (int) $_POST['storage_limit'];
                $download = (int) $_POST['download_limit'];
                $upload = (int) ($_POST['upload_limit'] ?? 100);
                $u->create($_POST['password'], $storage * 1024 * 1024, $download, $upload);
                $msg = "User created.";
            }
        } elseif ($_POST['action'] === 'delete_user') {
            $u = new User($_POST['username']);
            $db = new DB(__DIR__ . '/data/users.json');
            $db->delete($_POST['username']);
            $msg = "User deleted.";
        } elseif ($_POST['action'] === 'update_user_limits') {
            $u = new User($_POST['username']);
            $data = $u->getData();
            if ($data) {
                $storage = (int) $_POST['storage_limit'];
                $download = (int) $_POST['download_limit'];
                $upload = (int) $_POST['upload_limit'];
                $packageName = $_POST['package_name'] ?? 'Custom Plan';
                $updates = [
                    'storage_limit' => $storage * 1024 * 1024,
                    'download_limit' => $download,
                    'upload_limit' => $upload,
                    'package_name' => $packageName
                ];
                $u->update($updates);
                $msg = "User limits updated.";
            }
        }
    }
}

$config = $configDB->getAll();
$users = User::getAllUsers();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - TurBay Cloud</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/style.css">
    <script src="https://unpkg.com/feather-icons"></script>
    <style>
        .input-inline {
            background: transparent !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
            padding: 0.5rem !important;
            width: 130px !important;
            text-align: center;
            margin: 0 !important;
            color: white;
            border-radius: 6px;
        }

        .input-inline:focus,
        .input-inline:hover {
            background: rgba(255, 255, 255, 0.1) !important;
            border-color: rgba(255, 255, 255, 0.3) !important;
        }

        /* Hide spin buttons */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }
    </style>
</head>

<body>
    <div class="admin-container">

        <!-- Animated Floating Header -->
        <div class="floating-header">
            <div style="display: flex; align-items: center; gap: 1rem;">
                <div
                    style="background: rgba(59, 130, 246, 0.2); width: 48px; height: 48px; border-radius: 12px; display: flex; align-items: center; justify-content: center;">
                    <i data-feather="cloud-lightning"
                        style="color: var(--accent-primary); width: 24px; height: 24px;"></i>
                </div>
                <div>
                    <h2 style="margin:0; font-size: 1.5rem; letter-spacing: -0.02em;">TurBay Admin</h2>
                    <div style="color: var(--text-secondary); font-size: 0.85rem;">System Configuration & Users</div>
                </div>
            </div>

            <a href="logout.php" class="btn secondary">
                <i data-feather="log-out"></i> Logout
            </a>
        </div>

        <?php if ($msg): ?>
            <div class="card" style="border-left: 4px solid var(--success); padding: 1rem; animation: fadeIn 0.5s;">
                <span style="color: var(--success)"><?= htmlspecialchars($msg) ?></span>
            </div>
        <?php endif; ?>

        <div style="display: grid; grid-template-columns: 3fr 1fr; gap: 2rem; align-items: start;">

            <!-- User Management -->
            <div class="card">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                    <h3>Users</h3>
                    <button onclick="document.getElementById('createUserForm').classList.toggle('hidden')"
                        class="btn-sm">
                        <i data-feather="user-plus"></i> New User
                    </button>
                </div>

                <!-- Create Form -->
                <div id="createUserForm" class="hidden"
                    style="background: rgba(0,0,0,0.2); padding: 1.5rem; border-radius: 12px; margin-bottom: 2rem; border: 1px solid rgba(255,255,255,0.05);">
                    <h4 style="margin-top:0; margin-bottom: 1rem;">Create New User</h4>
                    <form method="POST"
                        style="display: grid; grid-template-columns: repeat(5, 1fr) auto; gap: 1rem; align-items: end;">
                        <input type="hidden" name="action" value="create_user">
                        <div>
                            <input type="text" name="username" placeholder="Username" required style="margin:0">
                        </div>
                        <div>
                            <input type="password" name="password" placeholder="Password" required style="margin:0">
                        </div>
                        <div>
                            <input type="number" name="storage_limit" value="100000" placeholder="MB" required
                                style="margin:0">
                        </div>
                        <div>
                            <input type="number" name="upload_limit" value="100" placeholder="Files" required
                                style="margin:0">
                        </div>
                        <div>
                            <input type="number" name="download_limit" value="50" placeholder="Downloads" required
                                style="margin:0">
                        </div>
                        <div>
                            <button type="submit">Create</button>
                        </div>
                    </form>
                </div>

                <!-- Users Table -->
                <table>
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Package Name</th>
                            <th>Storage (MB)</th>
                            <th>Uploads (Limit)</th>
                            <th>Downloads (Limit)</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $username => $data): ?>
                            <?php if ($data['role'] === 'admin')
                                continue; ?>
                            <tr>
                                <td>
                                    <div style="display: flex; align-items: center; gap: 0.75rem;">
                                        <div
                                            style="background: rgba(255,255,255,0.05); padding: 0.5rem; border-radius: 50%;">
                                            <i data-feather="user" style="width: 16px; height: 16px;"></i>
                                        </div>
                                        <strong><?= htmlspecialchars($username) ?></strong>
                                    </div>
                                    <div class="text-muted text-sm" style="margin-left: 3rem;">
                                        <?= round(($data['used_storage'] ?? 0) / 1024 / 1024, 2) ?> MB used
                                    </div>
                                </td>

                                <form method="POST">
                                    <input type="hidden" name="action" value="update_user_limits">
                                    <input type="hidden" name="username" value="<?= htmlspecialchars($username) ?>">

                                    <td>
                                        <input type="text" name="package_name" class="input-inline"
                                            value="<?= htmlspecialchars($data['package_name'] ?? 'Custom Plan') ?>"
                                            style="width: 150px !important;">
                                    </td>
                                    <td>
                                        <input type="number" name="storage_limit" class="input-inline"
                                            value="<?= round(($data['storage_limit'] ?? 0) / 1024 / 1024, 0) ?>">
                                    </td>
                                    <td>
                                        <?= $data['used_uploads'] ?? 0 ?> /
                                        <input type="number" name="upload_limit" class="input-inline"
                                            value="<?= $data['upload_limit'] ?? 100 ?>">
                                    </td>
                                    <td>
                                        <?= $data['used_downloads'] ?? 0 ?> /
                                        <input type="number" name="download_limit" class="input-inline"
                                            value="<?= $data['download_limit'] ?? 50 ?>">
                                    </td>
                                    <td>
                                        <div style="display:flex; gap:0.5rem;">
                                            <button type="submit" class="btn-icon" title="Save"
                                                style="background: transparent; color: var(--success); box-shadow: none;">
                                                <i data-feather="check"></i>
                                            </button>
                                            <button type="button" class="btn-icon danger"
                                                onclick="if(confirm('Delete user?')) { this.nextElementSibling.submit(); }">
                                                <i data-feather="trash-2" style="width: 16px;"></i>
                                            </button>
                                            <form method="POST" style="display:none;">
                                                <input type="hidden" name="action" value="delete_user">
                                                <input type="hidden" name="username"
                                                    value="<?= htmlspecialchars($username) ?>">
                                            </form>
                                        </div>
                                    </td>
                                </form>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Configuration -->
            <div class="card">
                <h3>System Settings</h3>
                <form method="POST">
                    <input type="hidden" name="action" value="update_config">

                    <div style="margin-bottom: 1rem;">
                        <label style="font-size: 0.85rem; color: var(--text-secondary);">Bucket Name</label>
                        <input type="text" name="r2_bucket" value="<?= htmlspecialchars($config['r2_bucket'] ?? '') ?>"
                            required>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="font-size: 0.85rem; color: var(--text-secondary);">Endpoint URL</label>
                        <input type="text" name="r2_endpoint"
                            value="<?= htmlspecialchars($config['r2_endpoint'] ?? '') ?>" required>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="font-size: 0.85rem; color: var(--text-secondary);">Access Key ID</label>
                        <input type="text" name="r2_access_key"
                            value="<?= htmlspecialchars($config['r2_access_key'] ?? '') ?>" required>
                    </div>

                    <div style="margin-bottom: 1rem;">
                        <label style="font-size: 0.85rem; color: var(--text-secondary);">Secret Access Key</label>
                        <input type="password" name="r2_secret_key"
                            value="<?= htmlspecialchars($config['r2_secret_key'] ?? '') ?>" required>
                    </div>

                    <button type="submit" class="secondary" style="width: 100%">Update Config</button>
                </form>
            </div>
        </div>
    </div>
    <script>
        feather.replace();
    </script>
</body>

</html>