<?php

require_once 'DB.php';

class Auth
{
    private $db;
    private $usersFile = __DIR__ . '/../data/users.json';

    public function __construct()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        $this->db = new DB($this->usersFile);
    }

    public function login($username, $password)
    {
        $user = $this->db->get($username);

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user'] = $username;
            $_SESSION['role'] = $user['role'];
            return true;
        }
        return false;
    }

    public function logout()
    {
        session_destroy();
    }

    public function isLoggedIn()
    {
        return isset($_SESSION['user']);
    }

    public function isAdmin()
    {
        return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
    }

    public function getUser()
    {
        return $_SESSION['user'] ?? null;
    }

    public function requireLogin()
    {
        if (!$this->isLoggedIn()) {
            header('Location: /login.php');
            exit;
        }
    }

    public function requireAdmin()
    {
        $this->requireLogin();
        if (!$this->isAdmin()) {
            echo "Access Denied";
            exit;
        }
    }
}
